timer = 0
circles = {}
circleCount = 0
edgeBullets = {}
edgeBulletCount = 0
edgeBulletSide = false
bouncyCircles = {}
bouncyCircleCount = 0
bouncyCircleSide = false
flies = {}
flyCount = 0
flySide = false
bombs = {}
bombCount = 0
bombHeight = 70
normalBullets = {}
normalCount = 0
ringCenterX = 0
ringCenterY = 0
vineTargetX = 0
vineTargetY = 0
fingers = {}
fingerCount = 0

arenaTop = 175
arenaBottom = -175
arenaLeft = -300
arenaRight = 300

function Update()
    timer = timer + 1
    if timer < 90 then
    elseif timer < 270 then
        CreateCirclePatterns(timer - 90)
    elseif timer < 300 then
    elseif timer < 480 then
        CreateChaos(timer - 300)
    elseif timer < 660 then
        CreateEdgeBullets(timer - 480)
    elseif timer < 690 then
    elseif timer < 780 then
        CreateBouncyCircles(timer - 690)
    elseif timer < 930 then
    elseif timer < 1110 then
        CreateFlies(timer - 930)
    elseif timer < 1170 then
    elseif timer < 1350 then
        CreateCirclePatterns(timer - 1170)
    elseif timer < 1380 then
    elseif timer < 1560 then
        CreateChaos(timer - 1380)
    elseif timer < 1740 then
        CreateBombs(timer - 1560)
    elseif timer < 1770 then
    elseif timer < 2010 then
        CreateRings(timer - 1770)
    elseif timer < 2190 then
        CreateVines(timer - 2010)
    elseif timer < 2370 then
        CreateFingers(timer - 2190)
    elseif timer < 2550 then
        CreateEdgeBullets(timer - 2370)
    elseif timer < 2730 then
        CreateCirclePatterns(timer - 2550)
    elseif timer < 2910 then
        CreateChaos(timer - 2730)
    elseif timer < 3000 then
        CreateBouncyCircles(timer - 2910)
    elseif timer < 3150 then
    elseif timer < 3330 then
        CreateFlies(timer - 3150)
    elseif timer < 3510 then
        CreateFingers(timer - 3330)
    elseif timer < 3750 then
        CreateRings(timer - 3510)
    elseif timer < 3930 then
        CreateVines(timer - 3750)
    elseif timer == 4100 then
        CreateLastAttack()
    end
    UpdateCircles()
    UpdateEdgeBullets()
    UpdateBouncyCircles()
    UpdateFlies()
    UpdateBombs()
    UpdateNormal()
    UpdateFingers()
    if timer >= 4600 then
        EndWave()
    end
end

function CreateChaos(time)
    if time % 15 == 0 then
        CreateChaosHelper(-100, arenaTop)
        CreateChaosHelper(100, arenaTop)
    end
end

function CreateChaosHelper(x, y)
    local offsetX = Player.x - x
    local offsetY = Player.y - y
    local angle = math.atan2(offsetY, offsetX)
    local distance = math.sqrt(offsetX * offsetX + offsetY * offsetY)
    local angleOffset = 120 / distance
    for i = -1, 1 do
        local useAngle = angle + i * angleOffset
        local speedX = 8 * math.cos(useAngle)
        local speedY = 8 * math.sin(useAngle)
        local circle = CreateCircle(x, y, 16, speedX, speedY)
    end
end

function CreateCirclePatterns(time)
    if time % 15 == 0 then
        local angleOffset = 0
        if time % 30 == 0 then
            angleOffset = math.pi / 16
        end
        CirclePatternHelper(-100, arenaTop, math.pi - angleOffset, 13 * math.pi / 8 - angleOffset)
        CirclePatternHelper(100, arenaTop, 11 * math.pi / 8 + angleOffset, 2 * math.pi + angleOffset)
    end
end

function CirclePatternHelper(x, y, startAngle, endAngle)
    local angleOffset = (endAngle - startAngle) / 7
    for i = 0, 6 do
        local angle = startAngle + i * angleOffset
        local speedX = 5 * math.cos(angle)
        local speedY = 5 * math.sin(angle)
        local circle = CreateCircle(x, y, 16, speedX, speedY)
    end
end

function CreateCircle(x, y, radius, speedX, speedY)
    local circle = {}
    circle.x = x
    circle.y = y
    circle.radius = radius
    circle.speedX = speedX
    circle.speedY = speedY
    circle.bullets = {}
    local numBullets = 2 * math.pi * radius / 10
    for i = 1, numBullets do
        local angle = 2 * math.pi * i / numBullets
        local offsetX = radius * math.cos(angle)
        local offsetY = radius * math.sin(angle)
        local bullet = CreatePellet(x + offsetX, y + offsetY)
        bullet.SetVar('offsetX', offsetX)
        bullet.SetVar('offsetY', offsetY)
        table.insert(circle.bullets, bullet)
    end
    circles[circleCount] = circle
    circleCount = circleCount + 1
    return circle
end

function UpdateCircles()
    empty = true
    for i, circle in pairs(circles) do
        empty = false
        circle.x = circle.x + circle.speedX
        circle.y = circle.y + circle.speedY
        local bullets = circle.bullets
        for j = 1, #bullets do
            bullets[j].Move(circle.speedX, circle.speedY)
        end
        if circle.x + circle.radius < arenaLeft or
            circle.x - circle.radius > arenaRight or
            circle.y + circle.radius < arenaBottom or
            circle.y - circle.radius > arenaTop then
            for j = 1, #bullets do
                bullets[j].Remove()
            end
            circles[i] = nil
        end
    end
    if empty then
        circleCount = 0
    end
end

function CreateEdgeBullets(time)
    if time == 0 then
        edgeBulletSide = (math.random(2) == 1)
    end
    time = time % 120
    speed = 7
    local angle = math.pi * (time % 60) / 120
    if (time < 60) == edgeBulletSide then
        local bullet = CreatePellet(arenaLeft, arenaTop)
        angle = 2 * math.pi - angle
        bullet.SetVar('speedX', speed * math.cos(angle))
        bullet.SetVar('speedY', speed * math.sin(angle))
        edgeBullets[edgeBulletCount] = bullet
        edgeBulletCount = edgeBulletCount + 1
    else
        local bullet = CreatePellet(arenaRight, arenaTop)
        angle = math.pi + angle
        bullet.SetVar('speedX', speed * math.cos(angle))
        bullet.SetVar('speedY', speed * math.sin(angle))
        edgeBullets[edgeBulletCount] = bullet
        edgeBulletCount = edgeBulletCount + 1
    end
end

function UpdateEdgeBullets()
    for i, bullet in pairs(edgeBullets) do
        bullet.Move(bullet.GetVar('speedX'), bullet.GetVar('speedY'))
        if bullet.GetVar('speedX') * bullet.x >= 0 then
            bullet.sprite.alpha = bullet.sprite.alpha - 0.066
            if bullet.sprite.alpha <= 0 then
                bullet.Remove()
                edgeBullets[i] = nil
            end
        end
        if bullet.isactive and bullet.y < arenaBottom then
            bullet.Remove()
            edgeBullets[i] = nil
        end
    end
end

function CreateBouncyCircles(time)
    if time == 0 then
        bouncyCircleSide = (math.random(2) == 1)
    end
    if time % 30 == 0 then
        local circle = {}
        local x = 89 + math.random(21)
        if bouncyCircleSide then
            x = x * -1
        end
        circle.x = x
        local y = 100
        circle.y = y
        local radius = 40
        circle.radius = radius
        local speedX = 4 * math.sqrt(2)
        if math.random(2) == 1 then
            speedX = speedX * -1
        end
        circle.speedX = speedX
        circle.speedY = 4 * math.sqrt(2)
        circle.life = 300
        circle.bullets = {}
        local numBullets = 2 * math.pi * radius / 10
        for i = 1, numBullets do
            local angle = 2 * math.pi * i / numBullets
            local offsetX = radius * math.cos(angle)
            local offsetY = radius * math.sin(angle)
            local bullet = CreatePellet(x + offsetX, y + offsetY)
            bullet.SetVar('offsetX', offsetX)
            bullet.SetVar('offsetY', offsetY)
            table.insert(circle.bullets, bullet)
        end
        bouncyCircles[bouncyCircleCount] = circle
        bouncyCircleCount = bouncyCircleCount + 1
    end
end

function UpdateBouncyCircles()
    for i, circle in pairs(bouncyCircles) do
        local speedX = circle.speedX
        local speedY = circle.speedY
        circle.x = circle.x + speedX
        circle.y = circle.y + speedY
        local bullets = circle.bullets
        for j = 1, #bullets do
            bullets[j].Move(speedX, speedY)
        end
        local radius = circle.radius
        if circle.life > 0 then
            if (circle.x - radius < arenaLeft and circle.speedX < 0) or
                (circle.x + radius > arenaRight and circle.speedX > 0) then
                circle.speedX = speedX * -1
            end
            if (circle.y - radius < arenaBottom and circle.speedY < 0) or
                (circle.y + radius > arenaTop and circle.speedY > 0) then
                circle.speedY = speedY * -1
            end
        elseif circle.x + radius < arenaLeft or circle.x - radius > arenaRight or
            circle.y + radius < arenaBottom or circle.y - radius > arenaTop then
            for j = 1, #bullets do
                bullets[j].Remove()
            end
            bouncyCircles[i] = nil
        end
        circle.life = circle.life - 1
    end
end

function CreateFlies(time)
    if time == 0 then
        flySide = (math.random(2) == 1)
    end
    local x = arenaLeft
    local speedX = 5
    local speedY = -1
    if flySide then
        x = arenaRight
        speedX = -5
    end
    if time % 3 == 0 then
        local y = arenaBottom + math.random(2 * arenaTop)
        local bullet = CreatePellet(x, y)
        bullet.SetVar('speedX', speedX)
        bullet.SetVar('speedY', speedY)
        bullet.SetVar('homing', false)
        flies[flyCount] = bullet
        flyCount = flyCount + 1
    end
end

function UpdateFlies()
    empty = true
    for i, bullet in pairs(flies) do
        empty = false
        local speedX = bullet.GetVar('speedX')
        local speedY = bullet.GetVar('speedY')
        bullet.Move(speedX, speedY)
        if ((speedX > 0 and bullet.x > arenaRight - 50) or
            (speedX < 0 and bullet.x < arenaLeft + 50)) and
            not bullet.GetVar('homing') then
            bullet.SetVar('speedX', speedX / 5)
            bullet.SetVar('speedY', -5)
            bullet.SetVar('homing', true)
        end
        if bullet.x < arenaLeft - 100 or bullet.x > arenaRight + 100 or
            bullet.y < arenaBottom - 100 or bullet.y > arenaTop + 100 then
            bullet.Remove()
            flies[i] = nil
        elseif bullet.x < arenaLeft or bullet.x > arenaRight or
            bullet.y < arenaBottom or bullet.y > arenaTop then
            bullet.sprite.alpha = 0
        else
            bullet.sprite.alpha = 1
        end
    end
    if empty then
        flyCount = 0
    end
end

function CreateBombs(time)
    if time % 6 == 0 then
        local bomb = {}
        bomb.x = arenaLeft + 20 + 16 * math.random((arenaRight - 20) / 8)
        bomb.y = arenaTop
        bomb.progress = 0
        bomb.alpha = 1
        bomb.bullets = {}
        for x = -20, 20, 10 do
            local bullet = CreatePellet(bomb.x + x, arenaTop)
            bullet.SetVar('y', 0)
            table.insert(bomb.bullets, bullet)
            bullet = CreatePellet(bomb.x + x, arenaTop + bombHeight)
            bullet.SetVar('y', 1)
            table.insert(bomb.bullets, bullet)
        end
        for y = 10, bombHeight - 10, 10 do
            local bullet = CreatePellet(bomb.x - 20, arenaTop + y)
            bullet.SetVar('y', y / bombHeight)
            table.insert(bomb.bullets, bullet)
            bullet = CreatePellet(bomb.x + 20, arenaTop + y)
            bullet.SetVar('y', y / bombHeight)
            table.insert(bomb.bullets, bullet)
        end
        bombs[bombCount] = bomb
        bombCount = bombCount + 1
    end
end

function UpdateBombs()
    for i, bomb in pairs(bombs) do
        local y = bomb.y
        local speed = -2
        if bomb.progress == 1 then
            speed = -8
        elseif bomb.progress == 2 then
            speed = 4
            bomb.alpha = bomb.alpha - 0.015
        end
        bomb.y = y + speed
        local bullets = bomb.bullets
        for j = 1, #bullets do
            if bomb.progress < 2 then
                bullets[j].Move(0, speed)
            else
                local bullet = bullets[j]
                bullet.Move(0, speed * bullet.GetVar('y'))
                bullet.sprite.alpha = bomb.alpha
                if bomb.alpha <= 0 then
                    bullet.Remove()
                end
            end
        end
        if bomb.progress == 0 and bomb.y + bombHeight < arenaTop then
            bomb.progress = 1
        elseif bomb.progress == 1 and bomb.y <= arenaBottom then
            bomb.progress = 2
        end
        if bomb.alpha <= 0 then
            bombs[i] = nil
        end
    end
end

function CreateRings(time)
    time = time % 60
    if time == 0 then
        ringCenterX = Player.x
        ringCenterY = Player.y
    end
    if time % 2 == 0 and time < 20 then
        local angle = 2 * math.pi * (time / 2) / 10
        local xOffset = 80 * math.cos(angle)
        local yOffset = 80 * math.sin(angle)
        local bullet = CreateNormalBullet(ringCenterX + xOffset, ringCenterY + yOffset,
            -xOffset / 10, -yOffset / 10, 120 - time, false)
        Audio.PlaySound("pellet")
    end
end

function CreateVines(time)
    time = time % 60
    if time == 0 then
        vineTargetX = Player.x
        vineTargetY = Player.y
    end
    local x = -101 + math.random(201)
    local y = arenaTop
    local offsetX = vineTargetX - x
    local offsetY = vineTargetY - y
    local distance = math.sqrt(offsetX * offsetX + offsetY * offsetY)
    local multiplier = 10 / distance
    local bullet = CreateNormalBullet(x, y, offsetX * multiplier, offsetY * multiplier, 0, true)
end

function CreateNormalBullet(x, y, speedX, speedY, delay, stayInBox)
    local bullet = CreatePellet(x, y)
    bullet.SetVar('speedX', speedX)
    bullet.SetVar('speedY', speedY)
    bullet.SetVar('delay', delay)
    bullet.SetVar('stayInBox', stayInBox)
    normalBullets[normalCount] = bullet
    normalCount = normalCount + 1
    return bullet
end

function UpdateNormal()
    empty = true
    for i, bullet in pairs(normalBullets) do
        empty = false
        if bullet.GetVar('stayInBox') and
            bullet.x < arenaLeft or bullet.x > arenaRight or
            bullet.y < arenaBottom or bullet.y > arenaTop then
            bullet.sprite.alpha = 0
        else
            bullet.sprite.alpha = 1
        end
        if bullet.GetVar('delay') > 0 then
            bullet.SetVar('delay', bullet.GetVar('delay') - 1)
        else
            bullet.Move(bullet.GetVar('speedX'), bullet.GetVar('speedY'))
            if bullet.x < arenaLeft - 100 or bullet.x > arenaRight + 100 or
                bullet.y < arenaBottom - 100 or bullet.y > arenaTop + 100 then
                bullet.Remove()
                normalBullets[i] = nil
            end
        end
    end
    if empty then
        normalCount = 0
    end
end

function CreateFingers(time)
    if time % 15 == 0 then
        finger = {}
        finger.x = arenaLeft - bombHeight
        local x = arenaLeft - bombHeight
        local speedX = 2
        if math.random(2) == 1 then
            finger.x = arenaRight + bombHeight
            x = arenaRight
            speedX = -2
        end
        finger.speed = speedX
        local yBottom = Player.y - 100
        local yTop = Player.y + 100
        if yBottom < arenaBottom + 16 then
            yBottom = arenaBottom + 16
        elseif yTop > arenaTop - 16 then
            yTop = arenaTop - 16
        end
        local y = yBottom - 1 + math.random(yTop - yBottom + 1)
        finger.bullets = {}
        for dy = -16, 16, 8 do
            local bullet = CreatePellet(x, y + dy)
            table.insert(finger.bullets, bullet)
            bullet = CreatePellet(x + bombHeight, y + dy)
            table.insert(finger.bullets, bullet)
        end
        for dx = 10, bombHeight - 10, 10 do
            local bullet = CreatePellet(x + dx, y - 16)
            table.insert(finger.bullets, bullet)
            bullet = CreatePellet(x + dx, y + 16)
            table.insert(finger.bullets, bullet)
        end
        fingers[fingerCount] = finger
        fingerCount = fingerCount + 1
    end
end

function UpdateFingers()
    for i, finger in pairs(fingers) do
        local speed = finger.speed
        if (speed > 0 and finger.x > arenaLeft) or
            (speed < 0 and finger.x < arenaRight) then
            speed = speed * 4
        end
        finger.x = finger.x + speed
        for j = 1, #finger.bullets do
            finger.bullets[j].Move(speed, 0)
        end
        if (speed > 0 and finger.x > arenaRight) or
            (speed < 0 and finger.x < arenaLeft) then
            for j = 1, #finger.bullets do
                finger.bullets[j].Remove()
            end
            fingers[i] = nil
        end
    end
end

function CreateLastAttack()
    local x = 0
    local y = arenaTop
    local radius = 40
    local numBullets = 2 * math.pi * radius / 10
    for i = 1, numBullets do
        local angle = 2 * math.pi * i / numBullets
        CreateNormalBullet(x + radius * math.cos(angle), y + radius * math.sin(angle),
            0, -1, 0, true)
    end
end

function CreatePellet(x, y)
    local bullet = CreateProjectile('vbonetiny', x, y)
    bullet.sprite.SetAnimation({'vbonetiny', 'vbonetiny'}, 1 / 12)
    return bullet
end

function OnHit(bullet)
    if bullet.sprite.alpha >= 0.5 then
        Player.Hurt(3)
    end
end
